/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import club.sk1er.org.apache.commons.lang3.StringUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;

public class CachingWordListLoader {
    private static final LoadingCache<String, List<String>> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<String>>(){

        public List<String> load(@NotNull String fileInClassPath) throws IOException {
            return this.loadWordsFromPath(fileInClassPath);
        }

        private List<String> loadWordsFromPath(String filePath) throws IOException {
            ArrayList<String> result = new ArrayList<String>();
            if (!JLanguageTool.getDataBroker().resourceExists(filePath)) {
                return result;
            }
            try (InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(filePath);
                 Scanner scanner = new Scanner(inputStream, "utf-8");){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    if (line.trim().length() < line.length()) {
                        throw new RuntimeException("No leading or trailing space expected in " + filePath + ": '" + line + "'");
                    }
                    result.add(StringUtils.substringBefore(line, "#"));
                }
            }
            return result;
        }
    });

    public List<String> loadWords(String filePath) {
        return (List)cache.getUnchecked((Object)filePath);
    }
}

